﻿var questionnaireEditorQuestionController = function () {
    var questionnaireEditor = null;

    init = function (_questionnaireEditor) {
        questionnaireEditor = _questionnaireEditor;
        bindEvents();
    }

    bindEvents = function () {
        questionnaireEditor.container.on("dblclick", ".h-questionnaireItem", function () {
            var activeBlock = null;

            // Use the active block 
            if (questionnaireEditor.activeBlock != null) {
                activeBlock = questionnaireEditor.blockController.getBlockElementFromId(questionnaireEditor.activeBlock);
            }

            // If no active block or active block closed
            if (activeBlock == null || $(".v-questionsContainer:visible", activeBlock).length == 0) {
                var firstOpenBlock = $(".v-blockPanel .v-questionsContainer:visible:first", questionnaireEditor.container);

                // Take first open block or last block of page
                activeBlock = (firstOpenBlock.length > 0)
                    ? firstOpenBlock.closest(".v-blockPanel")
                    : $(".v-blockPanel:last", questionnaireEditor.container);

                // Make sure last block opened
                if (firstOpenBlock.length == 0 && activeBlock.length > 0 && $(".v-questionsContainer:visible", activeBlock).length == 0) {
                    $(".h-expandBlock .img-expand", activeBlock).click();
                }
            }

            if (activeBlock == null || activeBlock.length == 0) {
                a4.showErrorMessage(questionnaireEditor.resources.AddQuestionRequiresBlock);
            }
            else {
                _paq.push(['trackEvent', 'Survey-Edit-Questionnaire', 'Question Creation', $(this).find('.sprite-editor-icons').attr("title")]);
                createBlockItem(activeBlock, $(this).attr("data-id"), $(this).attr("data-section"), null, null,
                    function (result) {
                        $(".v-questionsContainer", activeBlock).append(result);
                    });
            }
        });

        questionnaireEditor.container.on("mouseenter", ".h-questionnaireItem", function () {
            var element = $(this);
            var id = element.attr("data-id");
            var section = element.attr("data-section");
            var preview = $("#previewQuestionContainer", questionnaireEditor.container);

            // Don't show if currently displayed item
            if (section != "PageBreak" && (preview.is(":hidden") || preview.attr("data-id") != id)) {
                questionnaireEditor.previewTimer = setTimeout(function () { showPreview(element, id, section); }, 500);
            }
            else {
                preview.hide();
            }
        });

        questionnaireEditor.container.on("mouseleave", ".h-questionnaireItem,#previewQuestionContainer", function (event) {
            var to = $(event.toElement);
            window.clearTimeout(questionnaireEditor.previewTimer);

            if (!to.hasClass("h-questionnaireItem") && to.closest(".h-popupMessage").length == 0) {
                $("#previewQuestionContainer", questionnaireEditor.container).hide();
            }
        });

        questionnaireEditor.container.on("mouseenter", ".v-blockItemPanel, .v-blockItemStructurePanel", function () {
            questionMouseEnter($(this));
        });

        questionnaireEditor.container.on("mouseleave", ".v-blockItemPanel, .v-blockItemStructurePanel", function () {
            questionMouseLeave($(this));
        });

        questionnaireEditor.container.on("change", ".v-blockCheck", function () {
            if (questionnaireEditor.isStructureViewMode) {
                var check = $(this).is(":checked");
                var blockPanel = $(this).closest(".block-panel");
                var id = questionnaireStructure.blockController.getBlockIdFromElement(blockPanel);
                $(".v-block-structure-content", blockPanel).show();
                var options = questionnaireStructure.getDisplayOptions();

                var callback = function () {
                    if (check) {
                        questionnaireStructure.checkBlockQuestions(blockPanel);
                    }
                    else {
                        questionnaireStructure.uncheckBlockQuestions(blockPanel);
                    }
                };

                if (blockPanel.hasClass("loaded")) {
                    questionnaireStructure.completeButtonToggle(id, blockPanel, true, false, callback);
                }
                else {
                    blockPanel.addClass("loading");
                    $(".h-waiting-icon", blockPanel).show();
                    questionnaireStructure.loadBlockContent(id, blockPanel, true, false, true, undefined, options, callback);
                }
            }
        });

        questionnaireEditor.container.on("change", ".v-questionCheck, .v-pageBreakCheck", function () {
            var check = $(this).is(":checked");

            if (!questionnaireEditor.isStructureViewMode) {
                checkSurveyOptionsDisplay();
            }
            else if (check) {
                var block = $(this).closest(".block-panel");
                $(".v-blockCheck", block).attr("checked", true)
            }
        });

        questionnaireEditor.container.on("click", ".h-expandQuestion", function () {
            toggleQuestion($(this), true);
        });

        questionnaireEditor.container.on("click", ".h-deletePageBreak", function () {
            questionnaireEditor.hideFindQuestionPanel();
            deleteItem($(this).closest(".v-blockItemPanel"));
        });

        questionnaireEditor.container.on("click", ".h-cancelEditQuestion", function () {
            questionnaireEditor.cancelEditQuestion();
        });

        questionnaireEditor.container.on("click", ".h-activateDeactivateQuestion", function () {
            var blockItemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItemPanel);
            var question = questionnaireEditor.getQuestionById(questionId);
            question.active = !question.active;
            a4.callServerMethod(questionnaireEditor.getUrl("ActivateDeactivateQuestion"), { surveyId: question.surveyId, questionId: questionId },
                function (result) {
                    if (result.success) {
                        surveyMenu.refresh();
                        $(".v-questionTitle", blockItemPanel).toggleClass("inactive", !question.active);
                        $(".v-inactiveQuestion", blockItemPanel).toggleClass("hidden", question.active);
                    }
                });
        });

        questionnaireEditor.container.on("click", ".h-advanceQuestionOptions > div", function () {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            displayQuestionAdvanceSettings(itemPanel);
        });

        questionnaireEditor.container.on("click", ".boxed-container .custom-checkbox-container.title", function () {
            var filterSectionAttr = $(this).parents(".boxed-container").data("section");
            if (filterSectionAttr) {
                const isChecked = $(this).find("input[type=checkbox]").is(":checked");
                $(`#${filterSectionAttr}Section`).toggle(isChecked);
                if (isChecked) {
                    $(".v-qeRichEditText:visible", $(this).parents(".boxed-container")).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, maxHeight: 150 });
                }
            }
        });

        questionnaireEditor.container.on("click", ".h-questionRevision > div", function () {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            displayQuestionRevision(itemPanel);
        });

        questionnaireEditor.container.on("click", ".h-editQuestion", function () {
            questionnaireEditor.hideFindQuestionPanel();

            var panel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(panel);

            if (questionnaireEditor.unsavedChange()) {
                questionnaireEditor.showUnsavedChangesConfirmation(
                    function () { questionnaireEditor.completedActionCallback = function () { editQuestion(panel, questionId, true); }; questionnaireEditor.savePreviouslyEditedItem(); },
                    function () { questionnaireEditor.cancelPreviouslyEditedItem(); editQuestion(panel, questionId); }
                );
            }
            else {
                questionnaireEditor.closePreviouslyEditedItem();
                editQuestion(panel, questionId);
            }
        });

        questionnaireEditor.container.on("click", ".h-saveQuestion", function () {
            saveQuestion($(this), false);
        });

        questionnaireEditor.container.on("click", ".v-blockItemPanel .h-editSkipLogic", function () {
            var blockItemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItemPanel);
            var autoSave = $(this).closest(".v-bannerOptions, .v-optionListItems").length > 0;  // Auto save if directly editing from banner or question 'more' menu
            var loadQuestionSkips = !blockItemPanel.data("askLogic") ? true : false;

            var loadEditContentFunction = function () {
                if (!loadQuestionSkips) {
                    a4.callServerMethod(questionnaireEditor.getUrl("QuestionSkipLogic"), { questionId: questionId, autoSave: autoSave, askLogic: blockItemPanel.data("askLogic"), skipLogic: blockItemPanel.data("skipLogic") },
                        function (result) {
                            $("iframe").contents().find('.v-questionSkipContent').html(result);
                            let question = $("#blockItemPanel" + questionId, a4.top().questionnaireEditor.container);
                            a4.top().a4logicEditor.setVariableAutoComplete($("iframe").contents().find(".v-questionAskEditor .v-logicEditor", document), question);
                            a4.top().a4logicEditor.setVariableAutoComplete($("iframe").contents().find(".v-questionSkipEditor .v-logicEditor", document), question);
                        });
                }
            }

            var openWindow = function () {
                modalDialog.showWindow(questionnaireEditor.getUrl("QuestionSkipLogicEditor", { questionId: questionId, autoSave: autoSave, loadContent: loadQuestionSkips }), 500, 650, { initFunction: loadEditContentFunction });
            }

            if (questionnaireEditor.unsavedChangesForLogic()) {
                questionnaireEditor.showUnsavedChangesForLogicConfirmation(function () {
                    questionnaireEditor.completedActionCallback = openWindow;
                    saveQuestion($(".h-saveQuestion", blockItemPanel), true);
                }, function () { });
            }
            else {
                openWindow();
            }
        });

        questionnaireEditor.container.on("click", ".h-editAdvanceLogic", function (e) {
            var blockItemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItemPanel);
            var autoSave = $(this).closest(".h-bannerHeader").length > 0 || $(this).closest(".v-bannerOptions, .v-optionListItems").length > 0;  // Auto save if directly editing from banner or question 'more' menu
            var loadQuestionActions = !blockItemPanel.data("preLoad") ? true : false;

            // Set edit compute variables
            questionnaireEditor.setEditComputeVariables();

            var loadEditContentFunction = function () {
                if (!loadQuestionActions) {
                    var preload = blockItemPanel.data("preLoad");
                    var postAnswer = blockItemPanel.data("postAnswer");

                    a4.callServerMethod(questionnaireEditor.getUrl("QuestionAdvanceLogic"), { questionId: questionId, autoSave: autoSave, preLoad: preload, postAnswer: postAnswer },
                        function (result) {
                            $("iframe").contents().find('.v-advanceContent').html(result);
                        });
                }
            }

            var openWindow = function () {
                modalDialog.showWindow(questionnaireEditor.getUrl("QuestionAdvanceLogic", { questionId: questionId, autoSave: autoSave, loadContent: loadQuestionActions }), 680, 960, { initFunction: loadEditContentFunction });
            }

            if (questionnaireEditor.unsavedChangesForLogic()) {
                questionnaireEditor.showUnsavedChangesForLogicConfirmation(function () {
                    questionnaireEditor.completedActionCallback = openWindow;
                    saveQuestion($(".h-saveQuestion", blockItemPanel), true);
                }, function () { });
            }
            else {
                openWindow();
            }

            e.stopPropagation();
        });

        questionnaireEditor.container.on("click", ".h-editAdvanceLogicAction", function () {
            var blockItemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItemPanel);
            var banner = $(this).closest(".v-logicBanner");
            var actionId = banner.attr("data-actionId");
            var type = banner.attr("data-actionType");
            var branchType = (type == "BranchTo" || type == "ExitSurvey");
            var page = branchType ? "BranchToAndExitSurveyEditor" : "LogicActionEditor";
            var windowHeight = branchType ? 400 : 550;

            if (type == "ComputeVariable") {
                questionnaireEditor.setEditComputeVariables();
            }

            modalDialog.showWindow(questionnaireEditor.getUrl(page, { questionId: questionId, actionId: actionId, useActionContent: true, actionType: type, autoSave: true }), windowHeight, 920);
        });

        questionnaireEditor.container.on("click", ".v-questionEdit .h-changeQuestionType", function () {
            showQuestionTypesPanel($(this), function () {
                $(document).bind("click.hideQuestionTypesPanel", function (e) { hideQuestionTypesPanel(); });
            });
        });

        questionnaireEditor.container.on("click", ".v-questionTypesPanel .type-item:not(.disabled)", function (e) {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);
            var newQuestionType = $(this).find("a").attr("data-type");
            var oldQuestion = questionnaireEditor.getQuestionById(questionId);
            var oldQuestionType = questionnaireEditor.getQuestionsTypeById(oldQuestion.type).name;
            var inQuestionEditMode = $(this).closest(".v-questionEdit").size() > 0;

            $(this).closest(".v-questionTypesPanel").css("display", "none");

            if (newQuestionType != oldQuestionType) {
                var newQuestionVariableType = $(this).find("a").attr("data-variable-type");
                var questionVariables = _.filter(questionnaireEditor.getQuestionVariables(questionId), function (variable) { return variable.type != 2; });

                var proceedWithQuestionTypeChange = function () {
                    $(".h-cancelEditQuestion", itemPanel).click();
                    changeQuestionType(itemPanel, questionId, newQuestionType, inQuestionEditMode);
                };

                var showMorphConfirmDialog = function (confirmationMessage) {
                    modalDialog.showConfirmDialog(modalDialog.createDialogResources(
                        confirmationMessage,
                        questionnaireEditor.resources.ChangeQuestionMultiToSingle,
                        questionnaireEditor.resources.ChangeQuestionMultiToSingleCheck),
                        function () { proceedWithQuestionTypeChange(); },
                        220, 500);
                };

                if (((newQuestionVariableType == "single") || (oldQuestionType == "HybridGrid" && newQuestionVariableType == "multi" && questionnaireEditor.hybridGridHasMultipleColumns(questionId)))
                    && questionVariables.length > 1) {
                    showMorphConfirmDialog(questionnaireEditor.resources.ChangeQuestionMultiToSingleConfirmation); // looses variables
                } else if (oldQuestionType.indexOf("HybridGrid") != -1
                    && newQuestionType.indexOf("Grid") != -1) {
                    showMorphConfirmDialog(questionnaireEditor.resources.ChangeQuestionGridToMultiConfirmation); // looses grid settings

                } else {
                    proceedWithQuestionTypeChange();
                }
            } else {
                a4.showErrorMessage(questionnaireEditor.resources.MorphSameQuestionTypes);
            }

            e.stopPropagation();
        });

        questionnaireEditor.container.on("click", ".h-addToLibrary", function () {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);
            var questionName = $(".h-questionTitle", itemPanel).text();

            var showPopup = function () {
                questionnaireEditor.showAddToLibraryDialog(questionName,
                    function (newName, categoryId) {
                        addQuestionsToLibrary(questionId, newName, categoryId, true, false);
                    });
            }

            questionnaireEditor.loadQuestionCategories(showPopup);
        });

        questionnaireEditor.container.on("click", ".h-copyQuestion", function () {
            var blockItemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItemPanel);
            var question = questionnaireEditor.getQuestionById(questionId);
            var block = questionnaireEditor.getBlockById(question.blockId);

            questionnaireEditor.showLocationDialog(questionnaireEditor.resources.CopySelectedQuestion, true, block, question,
                function (moveToBlockId, moveLocation, moveQuestionId, nbTimes) {
                    copyBlockItems(moveToBlockId, moveLocation, moveQuestionId, questionId, nbTimes);
                    questionnaireEditor.refreshQuestionnaireTotalCount(0, nbTimes);
                });
        });

        questionnaireEditor.container.on("click", ".h-moveQuestion", function () {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);

            questionnaireEditor.showLocationDialog(questionnaireEditor.resources.MoveQuestionTo, false, null, null,
                function (moveToBlockId, moveLocation, moveQuestionId) {
                    moveMultipleItems($.makeArray(questionId), moveToBlockId, moveLocation, moveQuestionId, 1);
                });
        });

        questionnaireEditor.container.on("click", ".h-splitBlock", function () {
            var itemPanel = $(this).closest(".v-blockItemPanel");
            var blockPanel = itemPanel.closest(".v-blockPanel");
            var blockId = questionnaireEditor.blockController.getBlockIdFromElement(blockPanel);
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);

            questionnaireEditor.showSplitBlockDialog(
                function (newBlockName) {
                    splitIntoBlock(blockId, questionId, newBlockName);
                });
        });

        questionnaireEditor.container.on("click", ".h-deleteQuestion", function () {
            questionnaireEditor.hideFindQuestionPanel();
            var panel = $(this).closest(".v-blockItemPanel");
            deleteItem(panel);
        });

        questionnaireEditor.container.on("click", ".v-questionTitleEdit", function () {
            var questionTitleEditButton = $(this);

            if (questionnaireEditor.unsavedChange()) {
                questionnaireEditor.showUnsavedChangesConfirmation(
                    function () { questionnaireEditor.completedActionCallback = function () { editQuestionTitle(questionTitleEditButton, true); }; questionnaireEditor.savePreviouslyEditedItem(); },
                    function () { questionnaireEditor.cancelPreviouslyEditedItem(); editQuestionTitle(questionTitleEditButton, null); }
                );
            }
            else {
                questionnaireEditor.closePreviouslyEditedItem();
                editQuestionTitle(questionTitleEditButton, null);
            }

            return false;
        });

        questionnaireEditor.container.on("click", ".v-blockItemPanel .h-deleteSkipLogic", function () {
            var panel = $(this).closest(".v-blockItemPanel");
            deleteSkipLogic(panel);
        });

        questionnaireEditor.container.on("click", ".h-deleteAdvanceLogic", function () {
            var banner = $(this).closest(".v-logicBanner");
            var actionId = banner.attr("data-actionId");
            var panel = banner.closest(".v-blockItemPanel");
            deleteLogicItem(panel, banner, actionId);
        });
    }

    showQuestionTypesPanel = function (item, callback) {
        var interchangeableQuestionTypes = [
            ["NumericAnswer", "TextAnswer", "EmailAddressAnswer", "RespondentEmail", "RespondentPhone"],
            ["RadioButton", "CheckBox", "DropDownList"]
        ];

        questionnaireEditor.hideFindQuestionPanel();

        var itemPanel = item.closest(".v-blockItemPanel");
        var questionTypesPanel = $(".v-questionTypesPanel", item);
        questionTypesPanel.html($("#changeQuestionType", questionnaireEditor.container).html());
        var questionType = $(".v-questionEdit", itemPanel).attr("data-qtypename");

        var interchangeableQuestionTypesForQuestion = interchangeableQuestionTypes
            .filter(a => a.some(t => t === questionType))
            .flatMap(a => a)
            .filter(t => t !== questionType);

        if (interchangeableQuestionTypesForQuestion) {
            interchangeableQuestionTypesForQuestion.forEach(questionType => {
                $("[data-type=" + questionType + "]", questionTypesPanel).parent().show();
            });
        }

        //questionTypesPanel.css(align, "100%");

        questionTypesPanel.show({
            duration: 50,
            easing: "linear",
            complete: function () {
                if (callback) {
                    callback();
                }
            }
        });
    }

    createBlockItem = function (block, id, section, previousItemId, position, callback) {
        var blockId = questionnaireEditor.blockController.getBlockIdFromElement(block);
        var action = "CreateBlockItem";
        var args = { blockId: blockId, sourceId: id, section: section, previousItemId: previousItemId, atPosition: position, nbQuestions: _.size(questionnaireEditor.questions.filter(q => q.type !== "36")) }; // 36 - Secured Temporary Variable

        if (section == "PageBreak") {
            action = "CreatePageBreak";
            args = { blockId: blockId, previousItemId: previousItemId, atPosition: position };
        }

        a4.callServerMethod(questionnaireEditor.getUrl(action), args,
            function (result) {
                questionnaireEditor.blockController.ensureBlockInstructionsRemoved(block);
                callback(result.content);
                questionnaireEditor.unloadEditedPanels();

                var newItem = questionnaireEditor.blockController.getBlockItemElementInBlockWithId(block, result.id);
                var dividerContent = "<div class='item-divider'></div>";

                if (newItem.prev().hasClass("v-blockItemPanel")) {
                    $(dividerContent).insertBefore(newItem);
                }
                else if (newItem.next().hasClass("v-blockItemPanel")) {
                    $(dividerContent).insertAfter(newItem);
                }

                if (section != "PageBreak") {
                    questionnaireEditor.setDisplayQuestionTypePreview(newItem, result.type);
                    questionnaireEditor.updateQuestionSettings(result.id, false, true, false);
                    updateBlockQuestionCount(blockId, true);
                    questionnaireEditor.refreshQuestionnaireTotalCount(0, 1);
                } else {
                    questionnaireEditor.checkSurveyMenuStatus();
                }
            });
    }

    adjustBlockDivisions = function (block) {
        var dividerContent = "<div class='item-divider'></div>";
        var items = $(".v-questionsContainer > div:not(.v-blockEmpty)", block);

        _.each(items, function (element) {
            var div = $(element);
            var next = div.next(":not(.v-blockEmpty)");
            var idx = div.index();

            if ((idx == 0 || idx == items.length) && div.hasClass("item-divider")) {
                div.remove();
            }
            else if (next.length > 0 && div.attr("class").trim() == next.attr("class").trim()) {
                if (div.hasClass("item-divider")) {
                    div.remove();
                }
                else {
                    $(dividerContent).insertBefore(next);
                }
            }
        });
    }

    copyBlockItems = function (blockId, moveLocation, moveQuestionId, blockItemIds, nbTimes) {
        var moveToBlock = questionnaireEditor.blockController.getBlockElementFromId(blockId);
        var moveToItem = $(".v-questionsContainer", moveToBlock);
        var destLocation = "EmptyBlock";
        var destQuestionId = 0;

        if (moveQuestionId != null) {
            moveToItem = questionnaireEditor.blockController.getBlockItemElementFromId(moveQuestionId);
            destLocation = moveLocation;
            destQuestionId = moveQuestionId;
        }

        a4.callServerMethod(questionnaireEditor.getUrl("CopyBlockItems"), { blockId: blockId, blockItemIds: blockItemIds, moveLocation: moveLocation, moveToBlockItemId: moveQuestionId, nbQuestions: _.size(questionnaireEditor.questions), nbTimes: nbTimes },
            function (result) {
                var block = questionnaireEditor.blockController.getBlockElementFromId(blockId);
                var appendCopied = block.hasClass("loaded");

                var callback = function () {
                    if (appendCopied) {
                        if (destLocation == "EmptyBlock") {
                            $(".v-blockEmpty", block).hide();
                            $(".v-questionsContainer", block).append(result.content);
                        }
                        else if (destLocation == "Over") {
                            $(result.content).insertBefore(moveToItem);
                        }
                        else if (destLocation == "Below") {
                            $(result.content).insertAfter(moveToItem);
                        }

                        adjustBlockDivisions(block);
                        questionnaireEditor.blockController.initBlockDefaultPreview(block);
                    }
                    var settings = $.parseJSON(result.settings);
                    questionnaireEditor.highlightCopied(+settings[0].QId, block);

                    block.scrollIntoView();
                    unselectAllQuestions();
                    questionnaireEditor.addItemsToSettings($.parseJSON(result.settings));
                    updateBlockQuestionCount(blockId, false, true);
                };

                questionnaireEditor.blockController.executeActionOnBlock(block, true, callback);
                questionnaireEditor.checkSurveyMenuStatus();
            });
    }

    addQuestionsToLibrary = function (blockItemIds, newName, categoryId, single, selection) {
        var args = { blockItemIds: blockItemIds, name: newName, categoryId: categoryId };
        a4.callServerMethod(questionnaireEditor.getUrl("AddQuestionsToLibrary"), args,
            function (result) {
                var message = (single) ? questionnaireEditor.resources.QuestionAddedToLibrary : questionnaireEditor.resources.QuestionsAddedToLibrary;
                a4.showSuccessMessage(htmlDecode(message).replace("{0}", result), 2500);

                if (selection) {
                    unselectAllQuestions();
                }

                // Unload my library folder
                var myLibrary = $(".v-questionSelector .v-libraryBrowser .v-folderParent .v-sectionHeader[data-section='MyLibrary']", questionnaireEditor.container);
                var categoryfolder = $(".h-folder[data-id='" + categoryId + "']", myLibrary.parent());
                categoryfolder.siblings(".v-folderList").html("");
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            }
        );
    }

    splitIntoBlock = function (blockId, questionId, newBlockName) {
        a4.callServerMethod(questionnaireEditor.getUrl("SplitBlock"), { questionId: questionId, newBlockName: newBlockName },
            function (result) {
                var destQuestion = questionnaireEditor.getQuestionById(questionId);

                _.each(_.filter(questionnaireEditor.questions, function (q) { return q.blockId == blockId && q.position >= destQuestion.position }), function (bi) {
                    bi.blockId = result.id;
                });

                var startItem = $("#blockItemPanel" + questionId);
                startItem.nextAll().remove();
                startItem.remove();

                var block = questionnaireEditor.blockController.getBlockElementFromId(blockId);
                block.after(result.content);

                var newBlock = $(".v-questionsContainer", questionnaireEditor.blockController.getBlockElementFromId(result.id));
                questionnaireEditor.setBlockItemsSortable(newBlock);
                updateBlockQuestionCount(blockId, false, true);
                questionnaireEditor.refreshQuestionnaireTotalCount(1, 0);
                questionnaireEditor.checkSurveyMenuStatus();
                questionnaireEditor.highlightCopied(destQuestion, newBlock);
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            }
        );
    }

    moveMultipleItems = function (blockItemIds, moveToBlockId, moveLocation, moveToQuestionId, nbItems) {
        var moveToBlock = questionnaireEditor.blockController.getBlockElementFromId(moveToBlockId);
        var block = questionnaireEditor.getBlockById(moveToBlockId);
        var moveToItem = $(".v-questionsContainer", moveToBlock);
        var destLocation = "EmptyBlock";
        var destQuestionId = 0;

        if (moveToQuestionId != null) {
            moveToItem = questionnaireEditor.blockController.getBlockItemElementFromId(moveToQuestionId);
            destLocation = moveLocation;
            destQuestionId = moveToQuestionId;
        }

        a4.callServerMethod(questionnaireEditor.getUrl("MoveSelectedItems"), { blockItemIds: blockItemIds, moveToBlockId: moveToBlockId, moveLocation: moveLocation, moveToBlockItemId: moveToQuestionId },
            function (result) {
                var content = "";
                var appendQuestions = moveToBlock.hasClass("loaded");
                var destQuestion = (destQuestionId != 0) ? questionnaireEditor.getQuestionById(moveToQuestionId) : null;
                var destPosition = 0;
                var blockSources = [];
                blockSources.push(moveToBlockId);

                // Increment all question positions in destination block after destination. We increment by the number of items to let space for all moved questions
                if (destQuestion != null) {
                    _.each(_.filter(questionnaireEditor.questions, function (q) { return q.blockId == moveToBlockId && q.position > destQuestion.position }), function (bi) {
                        bi.position += nbItems;
                    });

                    destPosition = destQuestion.position;

                    if (destLocation == "Over") {
                        destQuestion.position += nbItems;
                    }
                    else {
                        destPosition++;
                    }
                }

                // Change positions of all moved questions to destination block and location
                _.each(blockItemIds, function (itemId) {
                    var q = questionnaireEditor.getQuestionById(itemId);
                    var currentItem = questionnaireEditor.blockController.getBlockItemElementFromId(itemId);

                    // Check if question
                    if (q) {

                        if (q.blockId == moveToBlockId && q.questionId == moveToQuestionId)
                            return;

                        // Keep track of blocks that have source questions being moved
                        if (!_.contains(blockSources, q.blockId)) {
                            blockSources.push(q.blockId);
                        }

                        q.blockId = moveToBlockId;
                        q.blockPosition = block.position;
                        q.position = destPosition++;
                    }

                    if (appendQuestions) {
                        content += currentItem.outerHTML();
                    }

                    // Get all dividers after item
                    var nextItem = currentItem.next();

                    while (nextItem.hasClass("item-divider")) {
                        content += nextItem.outerHTML();
                        nextItem = nextItem.next();
                    }

                    currentItem.remove();
                });


                // Either load block or add moved questions before opening
                var callback = function () {
                    if (appendQuestions) {
                        if (destLocation == "EmptyBlock") {
                            $(".v-questionsContainer", moveToBlock).append(content);
                        }
                        else if (destLocation == "Over") {
                            $(content).insertBefore(moveToItem);
                        }
                        else if (destLocation == "Below") {
                            $(content).insertAfter(moveToItem);
                        }
                    }

                    // Update previews
                    _.each(blockItemIds, function (itemId) {
                        var q = questionnaireEditor.getQuestionById(itemId);
                        var currentItem = questionnaireEditor.blockController.getBlockItemElementFromId(itemId);

                        if (q) {
                            var questionType = currentItem.find(".v-questionEdit").attr("data-qtypename");
                            questionnaireEditor.setDisplayQuestionTypePreview(currentItem, questionType);
                        }
                    });

                    // Update the questions count for all blocks that were affected by the move
                    _.each(blockSources, function (blockId) {
                        updateBlockQuestionCount(blockId, false, true);
                        var currentBlock = questionnaireEditor.blockController.getBlockElementFromId(blockId);
                        adjustBlockDivisions(currentBlock);
                    });

                    questionnaireEditor.blockController.ensureBlockInstructionsRemoved(moveToBlock);
                    questionnaireEditor.highlightCopied(blockItemIds[0], moveToBlock);
                    unselectAllQuestions();
                };

                // Execute open with set content callback
                questionnaireEditor.blockController.executeActionOnBlock(moveToBlock, true, callback);
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            }
        );
    }

    getSelectedQuestions = function () {
        var items = [];

        _.each($(".v-blockItemPanel .v-questionCheck:checked", questionnaireEditor.container), function (item) {
            items.push(questionnaireEditor.blockController.getBlockItemIdFromElement($(item)));
        });

        return items;
    }

    getSelectedQuestionsAndPageBreaks = function () {
        var items = [];

        _.each($(".v-blockItemPanel .v-questionCheck:checked, .v-blockItemPanel .v-pageBreakCheck:checked", questionnaireEditor.container), function (item) {
            items.push(questionnaireEditor.blockController.getBlockItemIdFromElement($(item)));
        });

        return items;
    }

    unselectAllQuestions = function () {
        $(".v-questionCheck", questionnaireEditor.container).prop("checked", false);
        $(".v-pageBreakCheck", questionnaireEditor.container).prop("checked", false);
        $(".v-toolbar", questionnaireEditor.surveyOptions).hide();
    }

    moveBlockItem = function (blockItemId, currentBlockId, destinationBlockId, previousBlockItemId, nextBlockItemId, moveUp) {
        a4.callServerMethod(questionnaireEditor.getUrl("MoveBlockItem"), { blockItemId: blockItemId, currentBlockId: currentBlockId, destinationBlockId: destinationBlockId, previousBlockItemId: previousBlockItemId, nextBlockItemId: nextBlockItemId, moveUp: moveUp },
            function (result) {
                var question = questionnaireEditor.getQuestionById(blockItemId);

                if (currentBlockId != destinationBlockId) {
                    updateBlockQuestionCount(currentBlockId, false, false);
                    updateBlockQuestionCount(destinationBlockId, true, false);
                }

                if (question) {
                    _.each(_.filter(questionnaireEditor.questions, function (q) { return q.blockId == destinationBlockId && q.position >= result.position }), function (bi) {
                        bi.position += 1;
                    });

                    question.position = result.position;
                    question.blockId = destinationBlockId;
                }
                questionnaireEditor.checkSurveyMenuStatus();
            },
            function (xhr, msg, e) {
                a4.onAjaxPageMethodError(xhr, msg, e);
                var block = questionnaireEditor.blockController.getBlockElementFromId(destinationBlockId);
                $(".v-questionsContainer", block).html("");
                questionnaireEditor.blockController.loadBlockContent(destinationBlockId, block, true, false, null, false);

                if (destinationBlockId != currentBlockId) {
                    var block = questionnaireEditor.blockController.getBlockElementFromId(currentBlockId);
                    $(".v-questionsContainer", block).html("");
                    questionnaireEditor.blockController.loadBlockContent(currentBlockId, block, true, false, null, false);
                }
            }
        );
    }

    resetBlockItemPanelIcons = function (blockItem) {
        $(".block-item-options", blockItem).hide();
        $(".v-moveBlockItem", blockItem).hide();
    }

    questionMouseLeave = function (blockItem) {
        resetBlockItemPanelIcons(blockItem);
    }

    checkSurveyOptionsDisplay = function () {
        $(".v-toolbar", questionnaireEditor.surveyOptions).toggle($(".v-blockItemPanel .v-questionCheck:checked, .v-blockItemPanel .v-pageBreakCheck:checked", questionnaireEditor.container).length > 0);
        $(".v-toolbar .v-questionsOnly", questionnaireEditor.surveyOptions).toggle($(".v-blockItemPanel .v-pageBreakCheck:checked", questionnaireEditor.container).length == 0);
    }

    editQuestion = function (panel, questionId, ignoreRequestInProcess) {
        questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(panel.closest(".v-blockPanel"));

        if (!a4.ajaxRequestInProcess || ignoreRequestInProcess) {
            $(".v-questionDisplay", panel).hide("slow");
            var questionType = $(".v-questionEdit", panel).attr("data-qtypename");

            a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionEditor"), { questionId: questionId },
                function (result) {
                    $(".v-questionEditorContainer", panel).html(result);
                    questionnaireEditor.initializeChoiceEditor(panel);
                    initEditor(questionType, panel, questionId);
                }
            );
        }
    }

    editQuestionTitle = function (questionEditTitleButton, ignoreRequestInProcess) {
        questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(questionEditTitleButton.closest(".v-blockPanel"));

        if (!a4.ajaxRequestInProcess || ignoreRequestInProcess) {

            var questionNameEditIcon = questionEditTitleButton.clone();
            var questionPanel = questionEditTitleButton.closest(".v-blockItemPanel");
            var questionId = questionPanel.attr("id").replace("blockItemPanel", "");
            var questionTitleGroupContainer = questionPanel.find(".v-questionTitleGroup");
            var questionTitleZoneContainer = questionPanel.find(".v-questionTitleEditZone");
            var questionTitleContainer = questionPanel.find(".v-questionTitle");
            var questionName = questionTitleContainer.html();
            var isMultiVariable = questionnaireEditor.questionIsMultiVariable(questionId);
            var questionNameInput = $("<input id=\"editQuestionTitle" + questionId + "\" type=\"text\" value=\"" + questionName + "\">")
                .on("click", function () {
                    return false;
                });

            questionNameInput.keypress(function (e) { return questionnaireEditor.disableInvalidCharacters(e); });

            questionnaireEditor.editValues[questionNameInput.attr("id")] = questionNameInput.val();

            var questionNameEditLoadingIcon = $(voxco.icons.getIcon("loading", "v-questionTitleEditLoading"));

            var questionNameEditCancelButton = $(voxco.icons.getIcon("remove", "question-title-edit-cancel v-questionTitleEditCancel", { Title: questionnaireEditor.resources.Cancel }))
                .on("click", function () {
                    questionnaireEditor.closeEditQuestionTitle();
                    questionnaireEditor.clearEditValues();
                });

            var questionNameEditConfirmButton = $(voxco.icons.getIcon("check", "question-title-edit-confirm v-questionTitleEditConfirm", { Title: questionnaireEditor.resources.Cancel }))
                .on("click", function () {
                    var newQuestionName = questionNameInput.val();

                    questionNameEditConfirmButton.hide();
                    questionNameEditCancelButton.hide();
                    questionTitleGroupContainer.append(questionNameEditLoadingIcon);

                    if ($.trim(newQuestionName) !== "") {
                        a4.callServerMethod(questionnaireEditor.getUrl("UpdateQuestionName"), { id: questionId, name: newQuestionName },
                            function (result) {
                                var question = questionnaireEditor.getQuestionById(questionId);
                                var variable = questionnaireEditor.getVariableByName(questionName);

                                //question.name = newQuestionName;
                                questionTitleContainer.html(result.name);

                                questionnaireEditor.closeEditQuestionTitle();

                                questionnaireEditor.clearEditValues();

                                questionnaireEditor.executeGlobalCallback(false);

                                if ((questionName != newQuestionName) && isMultiVariable) {
                                    promptForMultiVariableRename(questionId, newQuestionName, questionPanel);
                                } else {
                                    questionnaireEditor.updateQuestionSettings(questionId, true, true, false);
                                }
                            },
                            function (error) {
                                a4.onAjaxPageMethodError(error);
                                questionNameEditLoadingIcon.remove();
                                questionNameEditConfirmButton.show();
                                questionNameEditCancelButton.show();
                            }
                        );
                    } else {
                        a4.showErrorMessage(questionnaireEditor.resources.QuestionNameIsRequired);
                    }
                });

            //Allow confirmation with 'Enter' key
            questionNameInput.keypress(function (event) {
                if (event.keyCode == 13) {
                    questionNameEditConfirmButton.trigger("click");
                }
            });

            questionTitleZoneContainer.hide();

            questionTitleGroupContainer.append(questionNameInput);
            questionNameInput.focus();

            questionTitleGroupContainer.append(questionNameEditCancelButton);
            questionTitleGroupContainer.append(questionNameEditConfirmButton);

            questionTitleGroupContainer.addClass("inEditTitle");
        }
    }

    promptForMultiVariableRename = function (questionId, newQuestionName, questionPanel) {
        modalDialog.showConfirmDialog(questionnaireEditor.confirmRenameMultiVariablesResources, function () {
            a4.callServerMethod(questionnaireEditor.getUrl("RenameQuestionUnderlyingVariables"), { id: questionId, name: newQuestionName },
                function (result) {
                    questionnaireEditor.updateQuestionSettings(questionId, true, true, false);
                    questionPanel.find(".v-questionEditorContainer").empty();
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                });
        }, 250, 700, true, {}, {
            cancelButtonText: questionnaireEditor.resources.DontRenameVariables, cancelFunction: function () {
                questionnaireEditor.updateQuestionSettings(questionId, true, true, false);
            }
        });
    }

    initEditor = function (questionType, itemPanel, questionId) {
        var parent = itemPanel.find(".v-questionEditorContainer");
        itemPanel.find(".v-expandButton:visible").trigger('click');
        itemPanel.addClass("inEdit");
        itemPanel.addClass("edited");

        $(".v-questionDisplay", itemPanel).hide();
        $(".v-editMessage", itemPanel).hide();
        $(".v-questionLogic", itemPanel).hide();
        $(".v-npsPreviewFeedbackQuestion", itemPanel).hide();
        $(".v-questionEdit", itemPanel).show();
        $(".v-questionName", itemPanel).on("keypress", function (e) { return DisableInvalidCharacters(e); });

        questionnaireEditor.setSelectQuestionForChoicesEvent(itemPanel);
        questionnaireEditor.setRandomizationSynchronizeQuestionWithAutoComplete(itemPanel, questionId);
        questionnaireEditor.setQuestionOptionsByType(parent, itemPanel, questionType);

        if ($(".v-systemChoiceEditor", itemPanel).length > 0) {
            questionnaireEditor.setSystemChoicesWithAutoComplete(itemPanel);
        }

        //Initialize rich text editors
        $(".v-qeRichEditText:visible.v-questionEditText", itemPanel).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, minHeight: 100, maxHeight: 250 });
        $(".v-qeRichEditText:visible.v-questionEditTitle", itemPanel).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, minHeight: 50, maxHeight: 100 });
        $(".v-qeRichEditText:visible:not(.v-questionEditText, .v-questionEditTitle)", itemPanel).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, maxHeight: 150 });

        //Initialize numeric inputs
        questionnaireEditor.initializeNumericInputs(itemPanel);
        questionnaireEditor.initializeNumericAnswerInputs(itemPanel);

        //Set start values
        questionnaireEditor.setEditStartValues(itemPanel, questionType);
        questionnaireEditor.setSoftPromptChoiceAutoComplete(itemPanel, questionId, questionType);

        questionMouseEnter(itemPanel);

        //$('.v-openEndMinLength').autoNumeric("init", { wEmpty: 'zero', aPad: false, vMin: '0', vMax: '999999999999999', mDec: '0', aSep: '' });

        $(".question-main-options", itemPanel).trigger('optionsLoaded'); // For grids

        var buttons = $(".buttons-section", itemPanel);
        if (!IsScrolledIntoView(buttons)) {
            buttons.scrollIntoView();
        }
    }

    saveQuestion = function (button, stayInEdit) {
        var blockItem = button.closest(".v-blockItemPanel");
        var contentPanel = blockItem.find(".v-questionEdit");
        var id = questionnaireEditor.blockController.getBlockItemIdFromElement(blockItem);
        var inEdit = $(".v-questionName:visible", blockItem).length > 0;            // We can save the question without editing - for logic
        var nameSource = inEdit ? $(".v-questionName", blockItem).val() : $(".h-questionTitle", blockItem).text();
        var name = nameSource.trim().replace(/\s/g, '_');
        var previousName = questionnaireEditor.getQuestionById(id).name;
        var isMultiVariable = questionnaireEditor.questionIsMultiVariable(id);

        var questionType = contentPanel.attr("data-qtypename");
        $(".gridEditor", contentPanel).gridEditor("closeEdition");

        var choiceListIdControl = null
        var choiceListId;
        var settings = {};
        var translatableSettings = {};
        questionnaireEditor.errorOnRequest = false;

        if (inEdit) {
            $(".v-questionName", blockItem).trigger("focus");
            questionnaireEditor.validateName(name, questionnaireEditor.resources.NameRequired);
        }

        if (inEdit && !questionnaireEditor.errorOnRequest) {
            questionnaireEditor.setSettings(contentPanel, settings);
            questionnaireEditor.setTranslatableSettings(contentPanel, translatableSettings);
        }

        if (inEdit && !questionnaireEditor.errorOnRequest && $(".h-disableDateControlRoot").is(":visible")) {
            settings['DisabledDates'] = questionnaireEditor.disabledDateControl.toJSON();
        }

        if (inEdit && !questionnaireEditor.errorOnRequest && $(".v-choiceListEditor", contentPanel).is(":visible")) {
            if ($(".v-largeListEditor", contentPanel).length > 0) {
                settings["choiceLists"] = JSON.stringify($(".v-questionEditableItem:not(.deleted)", contentPanel).map(function () { return $(this).data("choices"); }).get());
            }
            else {
                settings["choices"] = JSON.stringify(blockItem.find(".v-choiceListTable .v-questionEditableItem:not(.deleted)").map(function () { return questionnaireEditor.choiceObject($(this), questionType); }).get());
            }

            choiceListIdControl = $(".v-choiceListEditor .v-useSameAsPanel:visible .v-choiceListId", blockItem);
            var sharedChoiceListId = choiceListIdControl.data("sharedid");
            choiceListId = choiceListIdControl.val();

            if (sharedChoiceListId != null && sharedChoiceListId != choiceListId) {
                settings["sharedchoicelistid"] = sharedChoiceListId;
                choiceListId = sharedChoiceListId;
            }
        }

        if (inEdit && !questionnaireEditor.errorOnRequest) {
            if ($(".v-systemChoiceListEditor", contentPanel).is(":visible")) {
                if ($(".v-largeListEditor", contentPanel).length == 0) {
                    settings["choices"] = JSON.stringify(blockItem.find(".v-choiceListTable .v-questionEditableItem:visible").map(function () { return questionnaireEditor.systemChoiceObject($(this)); }).get());
                }
            }
            else if ($(".v-cardListEditor", contentPanel).is(":visible")) {
                var cards = blockItem.find(".v-cardListTable .v-questionEditableItem:visible").map(function () {

                    var card = questionnaireEditor.cardObject($(this));
                    card.Text = $(this).find(".choice-text .fr-element").html()
                    return card;
                }).get();

                var cardsCount = (questionType === "Carrousel" && settings["choices"]) ? JSON.parse(settings["choices"]).length : cards.length;

                questionnaireEditor.validateCardsMinRequiredMaxAllowed(settings["MinRequiredAnswers"], settings["MaxAllowedAnswers"], cardsCount)

                if (!questionnaireEditor.errorOnRequest) {
                    settings["cards"] = JSON.stringify(cards);
                }
            }
            else if ($(".v-areaEditor", contentPanel).is(":visible")) {
                settings["areas"] = JSON.stringify(blockItem.find(".v-areaListTable .v-itemsBody .v-questionEditableItem:visible").map(function () { return questionnaireEditor.imageMapAreaObject($(this)); }).get());
            }
            else if ($(".v-drilldownEditor", contentPanel).is(":visible")) {
                settings["dropdowns"] = blockItem.find(".v-drilldownEditor .v-dropdownTable .v-questionEditableItem:visible").map(function () { return questionnaireEditor.dropdownObject($(this)); }).get();

                for (var i = 0; !questionnaireEditor.errorOnRequest && i != settings["dropdowns"].length; i++)
                    questionnaireEditor.validateMinMax(settings["dropdowns"][i].MinAnswers, settings["dropdowns"][i].MaxAnswers);

                if (!questionnaireEditor.errorOnRequest) {
                    settings["dropdowns"] = JSON.stringify(settings["dropdowns"]);
                }
            }
            else if ($(".v-openEndEditorContainer").is(":visible")) {
                var min = parseInt($("[data-name=MinAnswerLength]").val());
                var max = parseInt($("[data-name=MaxAnswerLength]").val());
                if (!isNaN(min) && !isNaN(max) && min > max) {
                    questionnaireEditor.errorOnRequest = true;
                    a4.showErrorMessage(questionnaireEditor.resources.MaxValueLowerThanMinValue);
                }
            }
            else if ($(".v-lookupTableEditorContainer", contentPanel).is(":visible")) {
                settings["lookupVariables"] = JSON.stringify(blockItem.find(".v-lookupColumnsEditor .v-lookupColumnsBody .v-questionEditableItem:visible").map(function () { return questionnaireEditor.lookupColumnObject($(this)); }).get());

                if ($(".v-lookupFilter", contentPanel).length > 0) {
                    var skipLogic = a4logicEditor.getLogic($(".v-lookupFilter", contentPanel), true);
                    questionnaireEditor.errorOnRequest = a4logicEditor.hasError;

                    if (!questionnaireEditor.errorOnRequest)
                        settings["Filter"] = JSON.stringify(skipLogic);
                }
            }
            else if ($(".v-highlightCategoryListEditor", contentPanel).is(":visible")) {

                // Save TextHighlight Categories (Variables)
                var categories = blockItem.find(".v-highlightCategoryListTable .v-questionEditableItem:visible").map(function () { return questionnaireEditor.categoryObject($(this)); }).get();
                if (!questionnaireEditor.errorOnRequest) {
                    settings["categories"] = JSON.stringify(categories);
                }

                // Save TextHighlight Tokens (Choices)
                var isHighlightTextView = blockItem.find(".v-textHighlighter-input").hasClass("highlighted");
                questionnaireEditor.cleanPressHistory();
                if (!isHighlightTextView) {
                    questionnaireEditor.setHighlightTextView();
                    $(".v-textHighlighter-input").toggleClass("highlighted");
                }

                settings["choices"] = JSON.stringify(blockItem.find(".v-textHighlighter-input .v-questionEditableItem:visible").map(function () { if ($(this).text().length > 0) { return questionnaireEditor.texthighlightChoiceObject($(this)); } }).get());
                settings["excludeStopwords"] = JSON.stringify(questionnaireEditor.getStopWordsList());

                // Save the format structure of Highlight View
                var originalContent = blockItem.find(".v-textHighlighter-input .fr-element").html();
                blockItem.find(".v-textHighlighter-input .v-questionEditableItem:visible").each(function () {
                    $(this).removeClass('selected');
                    var choiceCode = $(this).attr('mappedchoiceCode');
                    $(this).text('Choice_' + choiceCode);
                });
                settings["HighlightFormat"] = blockItem.find(".v-textHighlighter-input .fr-element").html();
                blockItem.find(".v-textHighlighter-input .fr-element").html(originalContent);
                questionnaireEditor.hideTooltip();
            }
        }
        // Validate question settings
        if (inEdit && !questionnaireEditor.errorOnRequest) {
            questionnaireEditor.validateSettings(contentPanel, questionType, settings, settings["choices"]);
        }

        if (!questionnaireEditor.errorOnRequest) {
            if (blockItem.data("askLogic")) {
                settings["askLogic"] = blockItem.data("askLogic");
                settings["skipLogic"] = blockItem.data("skipLogic");
            }

            if (blockItem.data("preLoad")) {
                settings["preLoad"] = blockItem.data("preLoad");
                settings["postAnswer"] = blockItem.data("postAnswer");
            }

            if (_.size(translatableSettings) == 0)
                translatableSettings = null;

            var args = { id: id, name: name, settings: settings, translatableSettings: translatableSettings };

            a4.callServerMethod(questionnaireEditor.getUrl("UpdateQuestion"), args,
                function (result) {
                    $(".v-questionName", blockItem).val(result.name);
                    $(".h-questionTitle", blockItem).text(result.name);

                    blockItem.find(".v-itemsContainer .deleted").each(function () { $(this).remove(); });
                    setQuestionPreview(blockItem, result.questionContent);

                    if (settings.active != null) {
                        $(".v-questionTitle", blockItem).toggleClass("inactive", !settings.active);
                        $(".v-inactiveQuestion", blockItem).toggleClass("hidden", settings.active);
                    }

                    $(".v-npsPreviewFeedbackQuestionSection", blockItem).html(result.npsFeedbackQuestion);

                    // Only update banner if changes were made
                    if (blockItem.data("askLogic")) {
                        $(".v-questionSkipRules", blockItem).html(result.skipLogic);
                    }

                    // Only update banner if changes were made
                    if (blockItem.data("preLoad")) {
                        $(".v-questionBranchRules", blockItem).html(result.bannerRules);
                        $(".v-questionAdvanceLogic", blockItem).html(result.advanceRules);
                        questionnaireEditor.propagateComputeVariableChanges();

                        // Remove to load from server after save
                        blockItem.removeData("preLoad");
                        blockItem.removeData("postAnswer");
                    }

                    // Empty the revision panel so it will be reloaded next time
                    var revisionPanel = $(".v-revisionContent", blockItem).html('');
                    $(".h-questionRevision", blockItem).trigger("click");

                    if (choiceListIdControl != null) {
                        choiceListIdControl.val(choiceListId);
                    }

                    var unload = (stayInEdit == undefined || !stayInEdit);

                    if (unload) {
                        questionnaireEditor.closeEditQuestion();
                    }
                    else if (questionEditionRequiresReload(blockItem)) {
                        questionEditionRequiresReload(blockItem, id);
                    }

                    questionnaireEditor.updateQuestionSettings(id, true, true, unload);    // Resets the questions settings - does global callback
                    reloadQuestionsWithSharedChoices(id, choiceListId, !unload);

                    if (name != previousName && isMultiVariable) {
                        promptForMultiVariableRename(id, name, contentPanel);
                    }
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                });
        }
    }

    updateSkipLogic = function (questionId, askLogic, skipLogic, autoSave) {
        var question = questionnaireEditor.blockController.getBlockItemElementFromId(questionId);

        if (question.length > 0) {
            if (!autoSave) {
                question.data("askLogic", askLogic);
                question.data("skipLogic", skipLogic);
            }
            else {
                a4.callServerMethod(questionnaireEditor.getUrl("UpdateSkipLogic"), { questionId: questionId, askLogicData: askLogic, skipLogicData: skipLogic },
                    function (result) {
                        $(".v-questionSkipRules", question).html(result.skipLogicBanner);
                        questionnaireEditor.checkSurveyMenuStatus();
                    },
                    function (error) {
                        a4.onAjaxPageMethodError(error);
                    });
            }
        }

        modalDialog.close();
    }

    updateAdvanceLogic = function (questionId, preLoad, postAnswer, autoSave) {
        var question = questionnaireEditor.blockController.getBlockItemElementFromId(questionId);

        if (question.length > 0) {
            question.data("preLoad", preLoad);
            question.data("postAnswer", postAnswer);
        }

        if (autoSave) {
            questionnaireEditor.completedActionCallback = function () { modalDialog.close(); };
            saveQuestion($("#blockItemPanel" + questionId + " .v-questionTitleGroup"), true);
        }
        else {
            modalDialog.close();
        }
    }

    reloadQuestionsWithSharedChoices = function (updatedQuestionId, choiceListId) {
        if (choiceListId) {
            var questionIds = _.pluck(questionnaireEditor.getQuestionsWithSameChoiceList(updatedQuestionId, choiceListId), "value");

            if (questionIds.length > 0) {
                a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionsContent"), { questionIds: questionIds },
                    function (result) {
                        for (var count = 0; count < result.length; count++) {
                            var questionId = result[count].Id;
                            var blockItemPanel = questionnaireEditor.blockController.getBlockItemElementFromId(questionId);
                            setQuestionPreview(blockItemPanel, result[count].Content);

                            if ($(".v-questionPreview", blockItemPanel).is(":visible")) {
                                var questionType = $(".v-questionEdit", blockItemPanel).attr("data-qtypename");
                                questionnaireEditor.setDisplayQuestionTypePreview(blockItemPanel, questionType);
                                questionMouseLeave(blockItemPanel);
                            }
                        }
                    },
                    function (error) {
                        a4.onAjaxPageMethodError(error);
                    });
            }
        }
    };

    questionEditionRequiresReload = function (blockItem) {
        return $(".v-questionEditableItem.deleted", blockItem).not("[id$='Row0']").length > 0
            || $(".v-choiceListBody #ChoiceRow0:not(.deleted)", blockItem).length > 0
            || $(".v-cardListTable #VariableRow0:not(.deleted)", blockItem).length > 0
            || $(".v-areaEditor #VariableRow0:not(.deleted)", blockItem).length > 0
            || $(".v-drilldownEditor #DropdownRow0:not(.deleted)", blockItem).length > 0
            || $(".v-lookupTableEditorContainer #ColumnRow0:not(.deleted)", blockItem).length > 0;
    }

    reloadQuestionEditor = function (blockItem, questionId) {
        var questionType = $(".v-questionEdit", blockItem).attr("data-qtypename");

        a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionEditor"), { questionId: questionId },
            function (result) {
                $(".v-questionEditorContainer", blockItem).html(result);
                questionnaireEditor.initializeChoiceEditor(blockItem);
                initEditor(questionType, blockItem, questionId);
            },
            function (error) { });
    };

    displayQuestionAdvanceSettings = function (itemPanel, forceLoad, clearFunction) {
        var advanceContent = $(".v-advanceSettings", itemPanel);
        var advanceHeader = advanceContent.prev();
        var parent = itemPanel.find(".v-questionEditorContainer");

        if (advanceContent.is(":visible")) {
            advanceContent.hide();
            $(".v-sectionTitle span", advanceHeader).toggle();
        }
        else if (forceLoad || !a4.ajaxRequestInProcess) {            // Verify if ajax call already in process
            if (advanceContent.html() != "") {
                completeAdvanceQuestionToggle(itemPanel, advanceHeader, advanceContent, forceLoad);
            }
            else {
                var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);

                a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionAdvanceEditor"), { questionId: questionId },
                    function (result) {
                        advanceContent.html(result);
                        questionnaireEditor.appendStartValuesForPanel(advanceContent);
                        questionnaireEditor.initializeChoiceEditor(advanceContent);

                        var questionType = $(".v-questionEdit", itemPanel).attr("data-qtypename");
                        questionnaireEditor.setQuestionAdvanceOptionsByType(parent, itemPanel, questionType);

                        questionnaireEditor.setSelectQuestionForChoicesEvent(advanceContent);
                        questionnaireEditor.setRandomizationSynchronizeQuestionWithAutoComplete(advanceContent, questionId);
                        questionnaireEditor.setSelectMultipleVariablesWithAutoComplete(advanceContent, questionId, questionType);
                        questionnaireEditor.setSelectMultipleChoicesWithAutoComplete(itemPanel, 0);

                        if (clearFunction)
                            clearFunction();

                        completeAdvanceQuestionToggle(itemPanel, advanceHeader, advanceContent, forceLoad);
                    },
                    function () { }
                );
            }
        }
    }

    completeAdvanceQuestionToggle = function (itemPanel, advanceHeader, advanceContent, backgroundLoading) {
        if (!backgroundLoading) {
            advanceContent.show();
            a4ImageSelector.bindElements(itemPanel);
            questionMouseEnter(itemPanel);
            $(".v-sectionTitle span", advanceHeader).toggle();
        }

        //Initialize richtext editors on complete because the editor will be loaded if the softprompt is selected to get the question choices
        $(".v-qeRichEditText:visible", advanceContent).a4richTextEditor({ library: true, piping: true, piping_system: true, inline: true, maxHeight: 150 });

        questionnaireEditor.initializeNumericInputs(itemPanel);
    }

    displayQuestionRevision = function (itemPanel) {
        var revision = $(".v-revisionContent", itemPanel);
        var revisionHeader = revision.prev();

        if (revision.is(":visible")) {
            completeRevisionToggle(itemPanel, revision, revisionHeader, false);
        }
        else if (!a4.ajaxRequestInProcess) {            // Verify if ajax call already in process
            if (revision.html() != "") {
                completeRevisionToggle(itemPanel, revision, revisionHeader, true);
            }
            else {
                var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(itemPanel);

                a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionRevision"), { questionId: questionId },
                    function (result) {
                        revision.html(result);
                        completeRevisionToggle(itemPanel, revision, revisionHeader, true);
                    },
                    function () { }
                );
            }
        }
    }

    completeRevisionToggle = function (itemPanel, revision, revisionHeader, show) {
        revision.toggle(show);
        $(".section-title span", revisionHeader).toggle();
    }

    changeQuestionType = function (panel, questionId, newQuestionType, inQuestionEditMode) {
        var questionTypesPanel = $(".v-questionTypesPanel", panel);
        var questionType = $(".v-questionEdit", panel).attr("data-qtypename");

        if (questionType != newQuestionType) {

            var args = { id: questionId, questionType: newQuestionType };
            a4.callServerMethod(questionnaireEditor.getUrl("ChangeQuestionType"), args,
                function (success) {
                    setQuestionPreview(panel, success);
                    questionnaireEditor.unloadQuestionEditPanel(panel);
                    questionnaireEditor.setDisplayQuestionTypePreview(panel, newQuestionType);
                    //UnloadQuestionEditorPanels(panel);

                    $(".changeQuestionTypeDiv span", panel).attr("class", "spriteEditorIcons img" + newQuestionType);
                    $(".selectQuestionTypeDiv", questionTypesPanel).removeClass("selected");

                    //Updating the question type attributes on the panel
                    var questionTypeInfo = questionnaireEditor.getQuestionsType(newQuestionType);
                    $(".v-questionTypeName", panel).text(questionTypeInfo.label);
                    $(".v-questionEdit", panel).attr("data-qtype", questionTypeInfo.value);
                    $(".v-questionEdit", panel).attr("data-qtypename", newQuestionType);

                    if (inQuestionEditMode) {
                        questionnaireEditor.completedActionCallback = function () { editQuestion(panel, questionId, true); };
                    }

                    questionnaireEditor.updateQuestionSettings(questionId, true, true);    // Resets the questions settings 
                },
                function () { }
            );
        }
    }

    hideQuestionTypesPanel = function () {
        $(".v-questionEdit .v-questionTypesPanel").hide("fast", "easeInOutQuart", function () {
            $(document).unbind("click.hideQuestionTypesPanel");
        });
    }

    deleteItem = function (item) {
        var itemId = questionnaireEditor.blockController.getBlockItemIdFromElement(item);


        if ($(".page-break", item).length > 0) {
            modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeletePageBreak, null, questionnaireEditor.resources.Delete),
                function () {
                    deleteItemConfirmed(item, itemId);
                    questionnaireEditor.checkSurveyMenuStatus();
                }, 220, 500);
        }
        else {
            // First get all the conflicts
            a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlockItems"), { blockItemIds: itemId, checkType: 1 },
                function (result) {
                    var height = 270;
                    var deleteContainer = $("#deleteQuestionContainer", questionnaireEditor.container).clone();
                    height = questionnaireEditor.addConflictsToContent(deleteContainer, result.conflicts, height);
                    messageContent = deleteContainer.html();

                    modalDialog.showConfirmDialog(modalDialog.createDialogResources(messageContent, questionnaireEditor.resources.DeleteQuestion, questionnaireEditor.resources.DeleteQuestionCheck, questionnaireEditor.resources.Delete),
                        function () {
                            var blockId = questionnaireEditor.blockController.getBlockIdFromElement(item);
                            deleteItemConfirmed(item, itemId)
                            updateBlockQuestionCount(blockId, false);
                            questionnaireEditor.refreshQuestionnaireTotalCount(0, -1);
                        }, height, 600, true);
                },
                function () { }
            );
        }
    }

    deleteItems = function (blockItemIds) {
        var height = 200;
        var width = 320;

        // First get all the conflicts
        a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlockItems"), { blockItemIds: blockItemIds, checkType: 1 },
            function (result) {
                width = 700;
                var deleteContainer = $("#deleteQuestionContainer", questionnaireEditor.container).clone();
                $(".deleteTitle", deleteContainer).html(questionnaireEditor.resources.DeleteQuestionsConfirmation);
                height = questionnaireEditor.addConflictsToContent(deleteContainer, result.conflicts, height);
                messageContent = deleteContainer.html();

                modalDialog.showConfirmDialog(modalDialog.createDialogResources(messageContent, questionnaireEditor.resources.DeleteItems, questionnaireEditor.resources.DeleteItemsCheck, questionnaireEditor.resources.Delete),
                    function () {
                        deleteItemsConfirmed(blockItemIds);
                    },
                    Math.min(height, 350), width, true);
            },
            function () { }
        );
    }

    deleteItemsConfirmed = function (itemIds) {
        a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlockItems"), { blockItemIds: itemIds, checkType: 2 },    // Resolve conflicts
            function () {
                var deletedQuestions = 0;

                _.each(itemIds, function (id) {
                    var isQuestion = (questionnaireEditor.getQuestionById(id) != null);
                    var item = questionnaireEditor.blockController.getBlockItemElementFromId(id);
                    var blockId = questionnaireEditor.blockController.getBlockIdFromElement(item)

                    if (isQuestion) {
                        deletedQuestions++;
                        updateBlockQuestionCount(blockId, false);
                    }

                    completeDeleteBlockItem(item, id);
                });

                questionnaireEditor.refreshQuestionnaireTotalCount(0, (deletedQuestions * -1));
                $(".v-toolbar", questionnaireEditor.surveyOptions).hide();
            },
            function () { }
        );
    }

    activateDeactivateQuestions = function (questionIds, activate) {
        a4.callServerMethod(questionnaireEditor.getUrl("ActivateDeactivateQuestions"), { questionIds: questionIds, activate: activate },
            function (result) {
                if (result.success) {
                    surveyMenu.refresh();
                    _.each(questionIds, function (id) {
                        var blockItemPanel = questionnaireEditor.blockController.getBlockItemElementFromId(id);
                        var question = questionnaireEditor.getQuestionById(id);
                        question.active = activate;
                        $(".v-questionTitle", blockItemPanel).toggleClass("inactive", !activate);
                        $(".v-inactiveQuestion", blockItemPanel).toggleClass("hidden", activate);
                    });
                }
            });
    }
    updateBlockQuestionCount = function (blockId, increment, recalculate) {
        var block = questionnaireEditor.blockController.getBlockElementFromId(blockId);
        var questionCountContainer = $(".v-blockName .v-nmbQuestions span", block);
        var questionCount = parseInt(questionCountContainer.html());

        if (recalculate) {
            questionCount = $(".v-blockItemPanel .v-questionEdit", block).length;   // Exclude page breaks
        }
        else if (increment) {
            questionCount += 1;
        }
        else {
            questionCount -= 1;
        }

        questionCountContainer.html(questionCount);
    }

    deleteItemConfirmed = function (item, itemId) {
        a4.callServerMethod(questionnaireEditor.getUrl("DeleteBlockItems"), { blockItemIds: itemId, checkType: 2 },    // Resolve conflicts
            function () {
                questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(item);
                completeDeleteBlockItem(item, itemId);
            },
            function () { }
        );
    }

    completeDeleteBlockItem = function (item, itemId) {
        var prev = item.prev();
        var next = item.next();

        if (prev.length != 0 && next.length != 0 && next.hasClass("item-divider") && prev.hasClass("item-divider")) {
            next.remove();
        }
        else if (prev.length == 0 && next.length != 0 && next.hasClass("item-divider")) {
            next.remove();
        }
        else if (next.length == 0 && prev.length != 0 && prev.hasClass("item-divider")) {
            prev.remove();
        }

        item.remove();

        // If not a page break
        if ($(".page-break", item).length == 0) {
            questionnaireEditor.updateQuestionSettings(itemId, true, false, false);
            questionnaireEditor.unloadEditedPanels();
            questionnaireEditor.removeReferencedBanners(itemId, true);
        }
    }

    deleteSkipLogic = function (item) {
        var itemId = questionnaireEditor.blockController.getBlockItemIdFromElement(item);
        var height = 200;
        var width = 400;

        modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeleteSkipLogic, null, questionnaireEditor.resources.Delete),
            function () {
                a4.callServerMethod(questionnaireEditor.getUrl("DeleteSkipLogic"), { blockItemId: itemId },
                    function (result) {
                        $(".v-questionSkipRules", item).html("");
                        questionnaireEditor.checkSurveyMenuStatus();
                    },
                    function () { }
                );
            },
            height, width);
    }

    deleteLogicItem = function (question, banner, id) {
        var itemId = questionnaireEditor.blockController.getBlockItemIdFromElement(question);

        modalDialog.showConfirmDialog(modalDialog.createDialogResources(sharedResources.DeleteItem, questionnaireEditor.resources.DeleteAction, null, questionnaireEditor.resources.Delete),
            function () {
                a4.callServerMethod(questionnaireEditor.getUrl("DeleteActionLogic"), { actionId: id },
                    function (result) {
                        var nbBanners = banner.siblings(".v-logicBanner").length;
                        var header = banner.closest(".v-bannerContainer");

                        if (banner.nextAll().length == 0 || banner.next().hasClass("v-branchSeparation")) {
                            banner.prevAll(".v-branchSeparation:first").remove();
                        }

                        if (nbBanners == 0) {
                            header.remove();
                        }
                        else {
                            var title = $(".v-bannerTitle", header);
                            title.text(nbBanners + " " + title.attr("data-title"));
                        }

                        $(".v-logicBanner[data-actionId='" + id + "']", question).remove();

                        // If Compute variable then remove associated variable
                        if (result != null) {
                            questionnaireEditor.variables = _.reject(questionnaireEditor.variables, function (v) { return v.value == result; });
                        }

                        questionnaireEditor.actionsLoaded = false;

                        questionnaireEditor.checkSurveyMenuStatus();
                    },
                    function (error) {
                        a4.onAjaxPageMethodError(error);
                    }
                );
            }, 220, 500);

    }

    verifyAndLoadEmptyBlockedScolledIntoView = function () {
        var found = 0;      // Use variable to only expand first few blocks that are into view (max 3). Reduce current load and create progressive load
        var processedIds = [];

        for (var i = 0; found < 3 && i != questionnaireEditor.expandAllBlocks.length; i++) {
            var block = questionnaireEditor.expandAllBlocks.get(i);

            if (IsScrolledIntoView(block)) {
                var expand = $(".v-questionsContainer", block);
                processedIds.push(block.id);
                questionnaireEditor.blockController.toggleBlock(expand, false, function () { questionnaireEditor.blockController.initializeExpandCollapse($("#" + processedIds.shift() + " .v-editQuestionContent.hidden")); }, true);
                ++found;
                questionnaireEditor.expandAllBlocks.splice(i--, 1);  // remove current item
            }
        }
    }

    completeExpandAll = function () {
        $(".v-blockPanel.loaded", questionnaireEditor.container).each(function () {
            var block = $(this);
            var expand = $(".v-questionsContainer:hidden", block);

            if (expand.length > 0) {
                questionnaireEditor.blockController.toggleBlock(expand, false, function () { questionnaireEditor.blockController.blockMouseLeave(block); });
            }

            var questions = $(".v-editQuestionContent.hidden", block);
            questionnaireEditor.blockController.initializeExpandCollapse(questions);
        });
    }

    toggleQuestion = function (button, withSave) {
        // Toggle current block display and button
        var itemPanel = button.closest(".v-blockItemPanel");
        var blockPanel = itemPanel.closest(".v-blockPanel");
        if (blockPanel.length < 1)
            return;

        var completeToggleQuestion = function () {
            var questionType = $(".v-questionEdit", itemPanel).attr("data-qtypename");

            if (withSave !== null && withSave) {
                questionnaireEditor.updateConfiguration(null, itemPanel);
            }

            questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(blockPanel);

            var content = $(".v-editQuestionContent", itemPanel);

            if (content.hasClass("hidden"))
                content.removeClass("hidden");
            else
                content.addClass("hidden");

            $(".h-expandQuestion:not(.h-questionTitle)", button.closest(".item-header")).toggle();

            questionMouseEnter(itemPanel);
            questionnaireEditor.setDisplayQuestionTypePreview(itemPanel, questionType);
        }

        if (itemPanel.hasClass("loaded") || itemPanel.hasClass("loading")) {
            completeToggleQuestion();
        }
        else {
            loadQuestionPreview(itemPanel, completeToggleQuestion);
        }
    }

    debounceLoadQuestionPreview = function (callback, delay) {
        var timeoutId;
        var questionIds = [];
        var questions = [];

        return function (questionId, questionElement, questionCallback) {
            questionIds.push(questionId);
            questions[questionId] = { element: questionElement, callback: questionCallback };

            clearTimeout(timeoutId);
            timeoutId = setTimeout(() => {
                callback(questionIds, questions);
                questionIds = [];
                questions = [];
            }, delay);
        };
    }

    loadQuestionPreviews = function (questionIds, questions) {
        a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionsContent"), { questionIds: questionIds },
            function (result) {
                for (var i = 0; i < result.length; i++) {
                    var item = result[i];
                    var question = questions[item.Id];

                    if (question) {
                        setQuestionPreview(question.element, item.Content);

                        var callback = question.callback;
                        if (callback) {
                            callback();
                        }
                    }
                }
            });
    }

    debouncedLoadQuestionPreview = debounceLoadQuestionPreview(loadQuestionPreviews, 50);

    loadQuestionPreview = function (element, callback) {
        element.addClass("loading");
        var id = questionnaireEditor.blockController.getBlockItemIdFromElement(element);
        debouncedLoadQuestionPreview(id, element, callback);
    }

    setQuestionPreview = function (element, content) {
        var questionPreview = $(".v-questionPreview", element);
        questionPreview.html(content);
        element.removeClass("loading").addClass("loaded");
    }

    questionMouseEnter = function (blockItem) {
        resetBlockItemPanelIcons(blockItem);
        $(".block-item-options", blockItem).css("display", "inline");
        $(".v-moveBlockItem", blockItem).show();

        if ($(".editable-content", blockItem).is(":visible")) {
            if ($(".page-break", blockItem).length > 0) {
                $(".block-item-options", blockItem).show();
            }
        }

        if ($(".v-editQuestionContent", blockItem).length > 0) {
            // $(".questionLogicDiv", blockItem).show();
        }
    }

    showPreview = function (element, id, section) {
        var preview = $("#previewQuestionContainer", questionnaireEditor.container);

        if (preview.attr("data-id") == id) {
            preview.show();
        }
        else {
            a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionBrowserPreview"), { questionId: id, section: section },
                function (result) {
                    var toolbox = $(".v-questionSelector", questionnaireEditor.container);
                    preview.attr("data-id", id);

                    $(".name", preview).remove();
                    $(".preview-container", preview).html(result);

                    preview.show();
                    preview.position({ my: "left center", at: "right center", of: element, collision: "none" });

                    questionnaireEditor.setSliders(preview);
                    questionnaireEditor.setStarRating(preview);
                });
        }
    }

    updateAction = function (questionId, actionId, actionType, properties, executionCondition) {
        var blockItemPanel = questionnaireEditor.blockController.getBlockItemElementFromId(questionId);
        var action = JSON.stringify(questionnaireEditor.actionUpdateObject(actionId, actionType, properties, executionCondition));

        a4.callServerMethod(questionnaireEditor.getUrl("UpdateAction"), { questionId: questionId, actionObject: action },
            function (result) {
                var banner = $(result.banner);
                $(".v-logicBanner[data-actionId='" + actionId + "']", blockItemPanel).replaceWith($(".v-logicBanner", banner));
                modalDialog.close();
                questionnaireEditor.checkSurveyMenuStatus();
                questionnaireEditor.propagateComputeVariableChanges();
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
    }

    return {
        init: init,
        showQuestionTypesPanel: showQuestionTypesPanel,
        createBlockItem: createBlockItem,
        adjustBlockDivisions: adjustBlockDivisions,
        copyBlockItems: copyBlockItems,
        addQuestionsToLibrary: addQuestionsToLibrary,
        moveMultipleItems: moveMultipleItems,
        getSelectedQuestions: getSelectedQuestions,
        getSelectedQuestionsAndPageBreaks: getSelectedQuestionsAndPageBreaks,
        unselectAllQuestions: unselectAllQuestions,
        moveBlockItem: moveBlockItem,
        resetBlockItemPanelIcons: resetBlockItemPanelIcons,
        questionMouseLeave: questionMouseLeave,
        checkSurveyOptionsDisplay: checkSurveyOptionsDisplay,
        editQuestion: editQuestion,
        editQuestionTitle: editQuestionTitle,
        promptForMultiVariableRename: promptForMultiVariableRename,
        initEditor: initEditor,
        saveQuestion: saveQuestion,
        updateSkipLogic: updateSkipLogic,
        updateAdvanceLogic: updateAdvanceLogic,
        displayQuestionAdvanceSettings: displayQuestionAdvanceSettings,
        updateBlockQuestionCount: updateBlockQuestionCount,
        verifyAndLoadEmptyBlockedScolledIntoView: verifyAndLoadEmptyBlockedScolledIntoView,
        completeExpandAll: completeExpandAll,
        toggleQuestion: toggleQuestion,
        updateAction: updateAction,
        deleteItems: deleteItems,
        activateDeactivateQuestions: activateDeactivateQuestions,
        deleteItemsConfirmed: deleteItemsConfirmed
    }
}